<?php

/**
 * Configuration Health Check
 * Run this file to verify your setup is correct
 * Access: https://yourdomain.com/config_check.php
 * DELETE THIS FILE AFTER CHECKING
 */

echo "<!DOCTYPE html>";
echo "<html>";
echo "<head><title>Configuration Health Check</title>";
echo "<style>body{font-family:Arial;margin:20px;} .ok{color:green;} .error{color:red;} .warning{color:orange;} h2{border-bottom:1px solid #ccc;padding-bottom:10px;}</style>";
echo "</head>";
echo "<body>";

echo "<h1>Configuration Health Check</h1>";
echo "<p><strong style='color:red;'>IMPORTANT: Delete this file after verification!</strong></p>";

$errors = [];
$warnings = [];
$ok = [];

// Check PHP Version
echo "<h2>PHP Version</h2>";
if (version_compare(PHP_VERSION, '7.4.0', '>=')) {
    echo "<p class='ok'>✓ PHP " . PHP_VERSION . " (OK)</p>";
    $ok[] = "PHP Version";
} else {
    echo "<p class='error'>✗ PHP " . PHP_VERSION . " (Requires PHP 7.4+)</p>";
    $errors[] = "PHP Version too old";
}

// Check Extensions
echo "<h2>Required PHP Extensions</h2>";
$required_extensions = ['curl', 'mysqli'];
foreach ($required_extensions as $ext) {
    if (extension_loaded($ext)) {
        echo "<p class='ok'>✓ $ext extension loaded</p>";
        $ok[] = ucfirst($ext) . " Extension";
    } else {
        echo "<p class='error'>✗ $ext extension NOT loaded</p>";
        $errors[] = "$ext extension missing";
    }
}

// Check Database Connection
echo "<h2>Database Connection</h2>";
require_once 'mainconfig.php';

if ($db) {
    echo "<p class='ok'>✓ Connected to database</p>";
    $ok[] = "Database Connection";
    
    // Check if accounts table exists
    $result = $db->query("SHOW TABLES LIKE 'accounts'");
    if ($result && $result->num_rows > 0) {
        echo "<p class='ok'>✓ 'accounts' table exists</p>";
        $ok[] = "Accounts Table";
        
        // Check table structure
        $columns = $db->query("DESCRIBE accounts");
        if ($columns && $columns->num_rows > 0) {
            echo "<p class='ok'>✓ Table structure verified</p>";
            $ok[] = "Table Structure";
        }
    } else {
        echo "<p class='error'>✗ 'accounts' table NOT found</p>";
        $warnings[] = "Run database.sql to create tables";
    }
} else {
    echo "<p class='error'>✗ Database connection failed</p>";
    echo "<p style='color:red;'>Error: " . htmlspecialchars($db->connect_error) . "</p>";
    $errors[] = "Database Connection Failed";
}

// Check File Permissions
echo "<h2>File Security</h2>";
$files_to_check = [
    '.htaccess' => 'Security configuration',
    'mainconfig.php' => 'Database config',
    'api_example.php' => 'API endpoint',
    'src/ApiGames.php' => 'API library'
];

foreach ($files_to_check as $file => $desc) {
    if (file_exists($file)) {
        echo "<p class='ok'>✓ $file exists ($desc)</p>";
        $ok[] = "File: $file";
    } else {
        echo "<p class='error'>✗ $file NOT found</p>";
        $errors[] = "Missing file: $file";
    }
}

// Summary
echo "<h2>Summary</h2>";
echo "<p><strong>✓ Passed:</strong> " . count($ok) . "</p>";
if (count($warnings) > 0) {
    echo "<p><strong style='color:orange;'>⚠ Warnings:</strong> " . count($warnings) . "</p>";
    foreach ($warnings as $warn) {
        echo "<p style='color:orange;'>- $warn</p>";
    }
}
if (count($errors) > 0) {
    echo "<p><strong style='color:red;'>✗ Errors:</strong> " . count($errors) . "</p>";
    foreach ($errors as $err) {
        echo "<p style='color:red;'>- $err</p>";
    }
    echo "<p style='color:red;'><strong>Please fix the errors above before using the API.</strong></p>";
} else {
    echo "<p class='ok'><strong>✓ All checks passed! Your configuration is ready.</strong></p>";
}

echo "<p style='margin-top:30px; border-top:1px solid #ccc; padding-top:20px;'>";
echo "<strong>Next Step:</strong> Test the API by sending a POST request to <code>api_example.php</code><br>";
echo "After verification, delete this file: <code>config_check.php</code>";
echo "</p>";

echo "</body></html>";
?>
