<?php

// Load environment variables from .env file
function loadEnv($file = '.env') {
    if (!file_exists($file)) {
        return false;
    }
    $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos($line, '=') !== false && strpos($line, '#') !== 0) {
            list($key, $value) = explode('=', $line, 2);
            $key = trim($key);
            $value = trim($value);
            if (!getenv($key)) {
                putenv("$key=$value");
            }
        }
    }
    return true;
}

// Load .env file
$env_loaded = loadEnv(__DIR__ . '/.env');

// Database configuration
define('DB_HOST', getenv('DB_HOST') ?: 'localhost');
define('DB_USER', getenv('DB_USER') ?: 'root');
define('DB_PASS', getenv('DB_PASS') ?: '');
define('DB_NAME', getenv('DB_NAME') ?: 'api_games');

// Create connection with prepared statements enabled
$db = @mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Check connection
if (!$db) {
    http_response_code(500);
    $error_msg = 'Database connection error';
    
    if (!$env_loaded) {
        $error_msg = 'ERROR: .env file not found. Rename .env.example to .env';
    } elseif (mysqli_connect_errno()) {
        // Log detailed error but don't expose in response
        error_log('Database Connection Error: ' . mysqli_connect_error());
        $error_msg = 'DATABASE ERROR: Check .env credentials and if database exists. See error logs.';
    }
    
    exit(json_encode(['response' => false, 'data' => ['msg' => $error_msg]]));
}

// Set character set to UTF-8
mysqli_set_charset($db, "utf8mb4");

// Enable error reporting for development (remove in production)
// error_reporting(E_ALL);
// ini_set('display_errors', 1);
